; PakFile Handling Routines 1.6
; Copyright Lee Page
; TeraBit Software 2001

Dim pakfiles$(1000)			;	These Arrays
Dim paklocate(1000)			;	Must be included
Dim PakSize(1000)			;	at the start of your Program.
Global PackCount			;	Items in the pack file.
Global key					;	The Encrytion Key
Global Packname$			; 	The Default is DATA.PAK
Global exeoffset			;	For use when Data is packed into an .EXE
Global pakAPND$				; 	Sets up the Name to append to the start of the unpacked filenames

; These are the Pak File Extraction Routines
;-----------------------------------------------------------------------

Function PakInit(myfile$,mykey,APND$,headermask)			; PackFile Initialisation

Local Headcount
Local pack
Local Retrieve
Local Offset
Local Block
Local Tem$
Local secbit
Local Hold
Local T
Local Fty
Local cnt
Local Filecnt

key = mykey	
pakApnd$=APND$
If FileType(myfile$)<>0 Then						; Check to see if the Archive Exists
packname$=myfile$									; If so set up Global Pack Name
Else												; Otherwise
packname$="Data.pak"								; Default to Data.Pak
EndIf												

If Upper$(Right$(packname$,4))=".EXE" Or Upper$(Right$(packname$,4))=".SCR" Then	; If the Archive is a .EXE File
retrieve = ReadFile(packname$)						; Open the Archive
SeekFile(retrieve,FileSize(packname$)-10)			; Find the Archive Data Section
exeoffset = ReadInt(retrieve)-1						; Set Global Offset to Data Section
exeoffset=exeoffset - headermask     ; New 
CloseFile(retrieve)									; Close Data Pack
EndIf		

pack = ReadFile(packname$)							; Open Archive
SeekFile(pack,exeoffset)							; Seek to Data Section (0 if DATA.PAK)
offset = ReadInt(pack)								; Find Header Information
offset = offset Xor headermask         ; New
SeekFile(pack,(offset-1)+exeoffset)					; Go to the Header
PackCount = ReadInt(Pack)							; Read the number of items in the pack

headcount=(FileSize(packname$)-FilePos(pack))+4
block = CreateBank(headcount)
ReadBytes block,pack,0,headcount-4
If key<>0 Then
For filecnt=1 To headcount-4 Step 4
hold=PeekInt(block,filecnt-1)
hold = hold Xor key
PokeInt block,filecnt-1,hold
Next 
EndIf
tem$ = ""
secbit=0
cnt = 1

For t=0 To headcount-5
If PeekByte(block,t)=13 Then 

	If fty = 0 Then 
	pakfiles$(cnt)=Upper$(tem$)
	EndIf

	If fty = 1 Then 
		paklocate(cnt)=tem$
		paklocate(cnt)=paklocate(cnt)+exeoffset
	EndIf

	If fty = 2 Then 
		Paksize(cnt)=tem$
		cnt=cnt+1
	EndIf
fty=fty+1
If fty=3 Then fty=0
tem$=""
;t=t+1
Else
tem$=tem$ + Chr$(PeekByte(block,t))
EndIf
Next 

	
FreeBank block										; Record this info in a Global Array
CloseFile (pack)									; for use by Other Functions
End Function										; Then Close the Archive

;-----------------------------------------------------------------------

Function pak$(pkf$)									; Get Filename to retrieve
Local cnt
Local item
Local Pack
Local Output
Local Block
Local filecnt
Local Hold
Local Ext$
Local Ex2$


For cnt=1 To packcount								; Count through Archive list
	If Upper$(pakfiles$(cnt))=Upper$(pkf$) Then		; If it exists in Archive
		item = cnt									; then set item to it's index
		Exit										; and break out of the loop
	EndIf
Next
If item = 0 Then 									; If no items were found
	Return pkf$										; Exit the subroutine
EndIf
pack = ReadFile(packname$)							; Open the Archive
SeekFile(pack,paklocate(item))						; Locate the Data in the store
output = WriteFile(pakapnd$+pakfiles$(item))		; Open the output File

block = CreateBank(paksize(item)+4)

ReadBytes block,pack,0,paksize(item)
If key<>0 Then
For filecnt=1 To paksize(item) Step 4
hold=PeekInt(block,filecnt-1)
hold = hold Xor key
PokeInt block,filecnt-1,hold
Next 
EndIf
WriteBytes block,output,0,paksize(item)

CloseFile(pack)										; Close Both files
CloseFile(output)
ext$ = Upper$(Right$(pkf$,4))
ex2$ = Upper$(Right$(pkf$,2))

FreeBank block

If ext$=".3DS" Or ex2$=".X" Or ext$="MD2" Then texcheck(pakapnd$+pkf$)
Return pakapnd$+pkf$								; Return the Filename
End Function

;-----------------------------------------------------------------------

Function texpak$(pkf$)									; Get Filename to retrieve

Local cnt
Local item
Local Pack
Local Output
Local Block
Local filecnt
Local Hold

For cnt=1 To packcount								; Count through Archive list
	If Upper$(pakfiles$(cnt))=Upper$(pkf$) Then		; If it exists in Archive
		item = cnt									; then set item to it's index
		Exit										; and break out of the loop
	EndIf
Next
If item = 0 Then 									; If no items were found
	Return pkf$										; Exit the subroutine
EndIf
pack = ReadFile(packname$)							; Open the Archive
SeekFile(pack,paklocate(item))						; Locate the Data in the store
output = WriteFile(pakfiles$(item))		; Open the output File

block = CreateBank(paksize(item)+4)

ReadBytes block,pack,0,paksize(item)
If key<>0 Then
For filecnt=1 To paksize(item) Step 4
hold=PeekInt(block,filecnt-1)
hold = hold Xor key
PokeInt block,filecnt-1,hold
Next 
EndIf
WriteBytes block,output,0,paksize(item)

CloseFile(pack)										; Close Both files
CloseFile(output)
FreeBank block
Return pkf$								; Return the Filename
End Function


;-----------------------------------------------------------------------

Function PakClean()									; Clean Up function to remove
Local cnt

For cnt=1 To packcount								; Leftover files
DeleteFile pakAPND$+pakfiles$(cnt)							; Deletes all files in the directory
Next												; That are contained in the Archive
End Function										; Keep Backups elsewhere and copy them in.

;-----------------------------------------------------------------------

Function TexPakClean()									; Clean Up function to remove
Local cnt

For cnt=1 To packcount								; Leftover files
DeleteFile pakfiles$(cnt)							; Deletes all files in the directory
Next												; That are contained in the Archive
End Function										; Keep Backups elsewhere and copy them in.

Function texcheck(modname$)
Local file
Local size
Local png
Local jpg
Local bmp
Local Bank
Local t
Local ser
Local m
Local tex$
Local k

file = ReadFile(modname$)

If file = 0 Then Return

size = FileSize(modname$)

bank = CreateBank(size+4)

png = svl(".png")
jpg = svl(".jpg")
bmp = svl(".bmp")

ReadBytes bank,file,0,size

CloseFile file

For t = 1 To size
	ser = PeekInt(bank,t)
		If ser = png Or ser = jpg Or ser = bmp Then
			m = t
			While PeekByte(bank,m)<>0 And m>0 And PeekByte(bank,m)<>34
				m=m-1
			Wend
			tex$ = ""
			For k=m+1 To t+3
				tex$=tex$+Chr$(PeekByte(bank,k))
			Next
			If FileType(tex$)=0 Then texpak(tex$)
		EndIf
Next

FreeBank bank
End Function

Function svl(ser$)
Local try
Local retval

try = CreateBank(4)

PokeByte try,0,Asc(Mid$(ser$,1,1))
PokeByte try,1,Asc(Mid$(ser$,2,1))
PokeByte try,2,Asc(Mid$(ser$,3,1))
PokeByte try,3,Asc(Mid$(ser$,4,1))

retval = PeekInt(try,0)

FreeBank try

Return retval

End Function